//
//  ShortcutButton.swift
//  SpeedKeys
//
//  Created by Jose Polo Ramos on 2/27/25.
//

import SwiftUI

// The Shortcut button, onPressed shows the modal capture window to record the shortcut.
// Displays the existing shortcut within its row.
struct ShortCutButton:View {
    
    @Binding   var data: Entries
    @State     private var showModal: Bool
    @State     private var shortCut: String = ""
    @Binding   var item:Entry
    
    init(data: Binding<Entries>, item: Binding<Entry>) {
        self._data = data
        self._item = item
        showModal = false
        shortCut  = self._item.wrappedValue.shortCut

    }
    
    var body: some View {
        Button(action: {
            showModal = true
        }) {
            Text(shortCut.isEmpty ? item.shortCut : shortCut)
                .foregroundColor(.yellow)
                .frame(width:100, height: 25, alignment: .center)
        }
        .buttonStyle(.borderless)
        .frame(width:100, height: 25, alignment: .trailing).sheet(isPresented: $showModal) {
            ShortcutSheet( showModal: $showModal, shortCut: $shortCut, data: $data, item: $item )
  }
    }
}
