/*	  ========================================================================================== 
 *     A Btree node should know its left most, right most and parent node.
 *     It should know its value and which level it lies on within the tree.
 * 
 */
class Node{

	/**
	 * Create a Node for the binary tree
	 * @param  {Node} left  the node on the left of this node; a child
	 * @param  {Node} right the node on the right of this node; a child
	 * @param  {Node} the parent node
	 * @return {void}       nothing
	 */
	constructor(left, right,height,value, x, y){
		this.left = left;
		this.right = right;
		this.height = height;
		this.value = value;
		this.x = x;
		this.y = y;
	}
   /**
    * This function updates the height of the Node 
    * * @return {[void]}            none
    */
	updateHeight()
	{
       // add to the greatest height of the current node or branches height.
   	 var l = this.left == null ? -1 : this.left.height;
   	 var r = this.right == null ? -1 : this.right.height;  	 
   	 this.height =  ( l > r ? l : r ) + 1 ;
	
	}
   /**
    * Render the node. 
    * @param  {[canvas]} the canvas object, on which; the node shall be drawn.
    * @return {[void]}             none
    */
	render(ctx)
	{
		var radius = 25;

		ctx.beginPath();
		ctx.arc(this.x, this.y,radius, 0, 2* Math.PI,false );
		ctx.fillStyle = '#fff';
		ctx.fill();
		ctx.lineWidth = 1;
		ctx.strokeStyle = 'MediumBlue';
		ctx.stroke();
		ctx.textBaseline="top";
		ctx.fillStyle="MediumBlue";
		ctx.font = "15px serif";
		ctx.fillText(this.value,this.x -10 , this.y - 10);
	}
};

/**
 *
 *     List Class  - this class represents a Linked List 
 *	  ========================================================================================== 
 *     A List Traverses, populates, diminishes and seeks values within itself.
 * 
 */
class List{

   /**
    * create the tree object 
    * @param  {[type]} screenWidth [description]
    * @return {[type]}             [description]
    */
   constructor(){
   	
   		this.root = null;
   		this.treeJSON = {};
   		this.depthLeft = 0;
   		this.depthRight = 0;
   		this.canvas = document.getElementById('llist');
   		this.ctx = this.canvas.getContext("2d");
      this.size = 0;

   }

   /**
    * Public function
    * Inserts a value into the AVL tree.
    */
   insert(value)
   {
   	 var val = Number(value);
   	 this.root = this.push( this.root, val);
   }
   /**
    * Finds a value and alerts when found.
    * @param {number} Value what we seek.
    * @return {Void} none.
    */
   seek(value)
   {
      var val = Number(value);
      this.root = this.find(this.root,val);
   }
   /**
    * seeks helper function to find the value in question.
    * @param {node} node the node in current traversal.
    * @param {number} value the value we seek.
    * @return {node} the current node.
    */
   find(node,value)
   {
      //found our node..print it.
      if (node.value == value)
      {
         alert("Found value: " + value);
      }
      // doesnt exist.
      else if ( node.right == null){
         alert("Oops that value: " + value +" doesn't exist!");
         return node;
      }
      // keep traversing 
      // the value we seek is to right of the branch since it is greater than this nodes value.
      else if (value > node.value)
         {
            node.right = this.find(node.right,value);

        }

         return node

   }

   /**
    * Deletes a value from the AVL tree
    * @param  {Number} value the number inserted into the tree
    * @return {Void}       none
    */
   delete(value){
   	 var val = Number(value);
   	 this.root = this.remove(this.root,val );
   }
   /**
    * Prints the tree.
    * @return {Void}       none
    */
   print()
   {
      // the json file is there should the tree ever need to be exported, meh..
   	this.treeJSON = {};
      // clear the canvas for a new drawing...
   	this.ctx.clearRect(0,0,this.canvas.width,this.canvas.height);
      
      // set the roots x and y coordinate..
      // note the canvas origin is as follows:
      //  _____________
      // | (0,0)
      // |

      this.root.x = 30;
      this.root.y = 30;

   	this.root =this.crawl(this.root ); 
   }
   /**
    * Hey lines are nice, why not, lets represent the connections to the node.
    * draw the line from the parent to the child.
    * @param  {parent} the parent node.
    * @param  {child} the child node.
    * @return {Void}       none
    */
   drawLine(left,right)
   {
    if (left == null && right == null ) return;

    var a = {x:left.x, y:left.y};
    var b = {x:right.x, y:right.y}
      // what better color than dark see green.
   	this.ctx.strokeStyle = 'DarkSeaGreen';

    if (b.x > a.x)
   	{
   		this.ctx.beginPath();
   		this.ctx.moveTo(a.x,a.y);
   		this.ctx.lineTo(b.x,b.y);
   		this.ctx.stroke();
   	}
    else{
      this.ctx.beginPath();
      this.ctx.moveTo(a.x,a.y);
      this.ctx.lineTo(this.canvas.width + 10,a.y);
      this.ctx.stroke();

      this.ctx.beginPath();
      this.ctx.moveTo(0,b.y);
      this.ctx.lineTo(b.x,b.y);
      this.ctx.stroke();

    }
   }
   /**
    * Uses recursion to traverse the tree, calls itself until the node is either inserted, found or deleted then unwraps 
    * upon itself back to the root.
    * @param  {node} the parent node, alas a beginning anew.
    * @param  {xinterval} as the trees branches grow for spaces sake, and aesthetics considered the 
    * distance between the nodes at their level will decrease as their height decreases.
    * @return {Void}       none
    */
   crawl(node  )
   {
   		var yinterval = 65;
      var xinterval = 110;
  		
         // starboard side until we insert at the leaf..
   		if(node.right != null)
   		{
    
        if (this.canvas.width - node.x > xinterval)
        {
          node.right.x = node.x + xinterval ;
          node.right.y = node.y;
        }
        else{
          node.right.x = 30;
          node.right.y = node.y + yinterval;
        }
       	
        //draw the lines and continue.
   			this.drawLine(node,node.right);
   			this.crawl(node.right);
   		}
   
       // draw the node...
		 node.render(this.ctx);	
		 return node;
   	
   }
   /**
    * If either side of the current branch or node is greater by more than 1 then the tree is unbalanced
    * and some manipulations are in order.
    * @param  {lt} the left side.
    * @param  {rt} the right side.
    * @return {Void}       none
    */
   unbalanced(lt,rt){
      // left (lt) or right (rt) are arbitrary
      // this function could be called at unbalanced(right,left)
      // and lt would really be right.
   	var l = lt == null ? -1 : lt.height;
   	var r = rt == null ? -1 : rt.height;

      // if the difference exceeds 1 it is unbalanced.
      return l - r > 1 ? true : false ;
   }

   /**
    * Places a node on the AVL tree as a leaf and then rebalances the tree should the need arise.
    * @param  {node} the current node on the traversal to the leafy greens, i.e. terminal point
    *                where the new node  is placed.
    * @param  {value} the value to be placed to the node.
    * @return {Node}  the node at the current traversal point.
    */
   push( node, value)
   { 
      // hey once the node is null meaning that either right or left is a terminal 
      // point we can create the node and insert it.
   		if(node == null)
      {
   			node =   new Node(null,null,-1,value, 0,0);
        this.size++;
   		 }
       //do not double place..
      // if(node.value == value)
      // {
      //   alert("that value: "+ value + " already exists!");
      //   return node;
      // }
      // not there yet if the value exceeds the current node go right.
   		else if (value > node.value)
   		{
      // go right.
   			node.right = this.push(node.right,value);
   		}
      // not there yet if the value exceeds the current node go left.
   		else if ( value < node.value)
   		{
        var _node = node;
        var node = new Node(null,null,node,value,0,0);
   			node.right = _node;
        this.size++;

   		}
   		return node;
   }

   /**
    * Removes a node from the tree.
    * @param  {node} the current node on the traversal to the leafy greens, i.e. terminal point
    *                where the damned node resides, poor soul.
    * @param  {value} the value to be deleted.
    * @return {Node}  the node at the current traversal point.
    */
   remove( node, value)
   { 
   	// the node to die has been found.
      if( value == node.value)
		{
         // pluck analyzes how we are to remove the node, 
         // to keep the integrity of the tree.
      this.size--;
			return node.right;
		}
      // didn't find our value.
      else if (node.right == null){
         alert("Oops that value doesn't: "+value+" exist!");
         return node;
      }
   	// keep traversing 
      // the value we seek is to right of the branch since it is greater than this nodes value.
      else if (value > node.value)
   		{
   			node.right = this.remove(node.right,value);

   	  }
   		return node;
   }



}



